//
//  GlyphsToolAuxiliaryDrawing.h
//  GlyphsCore
//
//  Created by Martin Winter on 20.06.18.
//  Copyright © 2018 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/**
 This is the base protocol for both `GlyphsToolDraw` and `GlyphsToolEvent`.
 */
@protocol GlyphsToolAuxiliaryDrawing <NSObject>

/** Draws some general things to the background of the edit view.

 This should be only additional items, as the actual glyphs are drawn by the layer plugin.

 @see drawForegroundInRect:

 @param dirtyRect The minimal rectangle that needs to be drawn. Implementers may use this to optimize their drawing.
 */
- (void)drawBackgroundInRect:(NSRect)dirtyRect;

/** Draws some general things to the foreground of the edit view.

 This should be only additional items, as the actual glyphs are drawn by the layer plugin.

 @see drawBackgroundInRect:

 @param dirtyRect The minimal rectangle that needs to be drawn. Implementers may use this to optimize their drawing.
 */
- (void)drawForegroundInRect:(NSRect)dirtyRect;

#pragma mark - Deprecated Methods

@optional

- (void)drawBackground DEPRECATED_MSG_ATTRIBUTE("Use -drawBackgroundInRect: instead.");

- (void)drawForeground DEPRECATED_MSG_ATTRIBUTE("Use -drawForegroundInRect: instead.");

@end
